/****** Object:  StoredProcedure [dbo].[P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA_ALL]    Script Date: 11/28/2013 09:36:38 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA_ALL]
GO
GO

--Versao 3252
--EXECUTE P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA_ALL 02, 2017
CREATE PROCEDURE [dbo].[P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA_ALL]( @MES INT=NULL, @ANO INT=NULL,@CD_FILIAL_PAR INT=0 )  WITH ENCRYPTION AS

	DECLARE @CD_EMP INT
 	DECLARE @CD_FILIAL INT
	DECLARE @AGORA DATETIME
	SET @CD_EMP=1
	SET NOCOUNT ON
	IF @ANO IS NULL OR @MES IS NULL
		begin
			SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
		end
	 
	DECLARE cTribFilial CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
		CD_EMP,
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = @CD_EMP
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
		
	OPEN cTribFilial
	FETCH NEXT FROM cTribFilial INTO @CD_EMP,@CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		  
		PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) 
		
		EXEC P_PDV_VD_IT_TRIBUTACAO_CADASTRO_VENDA_REALIZADA @CD_EMP,@CD_FILIAL,NULL,NULL,@ANO,@MES
		 
		FETCH NEXT FROM  cTribFilial INTO @CD_EMP,@CD_FILIAL 
	END
	
CLOSE cTribFilial
DEALLOCATE cTribFilial
